chrome.webNavigation.onCompleted.addListener((details) => {
    // Check if page has path segments (not homepage)
    const url = new URL(details.url);
    if (url.pathname !== '/') {
        chrome.scripting.executeScript({
            target: { tabId: details.tabId },
            function: solveRecaptcha
        });
    }
});

function solveRecaptcha() {
    // Find and modify reCAPTCHA elements
    const recaptchaElements = document.querySelectorAll('.g-recaptcha');
    
    recaptchaElements.forEach(element => {
        // Inject test site key
        element.setAttribute('data-sitekey', '6LeIxAcTAAAAAJcZVRqyHh71UMIEGNQ_MXjiZKhI');
        
        // Optional: Log for debugging
        console.log('reCAPTCHA element modified');
    });
}