(function () {
    const TEST_KEY = '6LeIxAcTAAAAAJcZVRqyHh71UMIEGNQ_MXjiZKhI';

    function isRecaptcha(el) {
        return el.classList.contains('g-recaptcha') || (el.src && el.src.includes('google.com/recaptcha'));
    }

    function replaceKeys() {
        let found = false;
        document.querySelectorAll('[data-sitekey]').forEach(el => {
            if (!isRecaptcha(el)) return;

            if (el.getAttribute('data-sitekey') !== TEST_KEY) {
                el.setAttribute('data-sitekey', TEST_KEY);
                found = true;
            }
        });

        // Retry if not found
        if (!found) {
            setTimeout(replaceKeys, 1000);
        }
    }

    replaceKeys();

    new MutationObserver(replaceKeys).observe(document.body, {
        childList: true,
        subtree: true
    });
})();